<?php
/**
 * 龙银支付宝扫码
 */
namespace app\common\pay;
use think\Request;
use app\common\Pay;
class LongyinAliScan extends Pay
{

    protected $gateway = 'http://hlgw.taixinyilian.com';
    protected $code='';
    protected $error='';

    public function getCode()
    {
        return $this->code;
    }

    public function getError()
    {
        return $this->error;
    }

    public function order($outTradeNo,$subject,$totalAmount)
    {
        $params['mch_id'] = $this->account->params->mch_id;
        $params['out_trade_no'] = $outTradeNo;
        $params['product_name'] = $subject;
        $params['amount'] = number_format($totalAmount,2,'.','');
        $params['notify_url'] = Request::instance()->domain().'/pay/notify/LongyinAliScan';
        $params['return_url'] = Request::instance()->domain().'/pay/page/LongyinAliScan';
        $params['bank_code'] = 'ZFBH52';

        $params['sign'] = $this->sign($params, $this->account->params->key);
        $response = postCurl($this->gateway.'/api/gateway/order/unite', json_encode($params));

        $this->code    =0;
        $obj           =new \stdClass();
        $obj->pay_url  =$response;
        $obj->content_type = 3;
        return $obj;

    }

    /**
     * 页面回调
     */
    public function page_callback($params,$order)
    {
        header("Location:" . url('/orderquery',['orderid'=>$order->trade_no]));
    }

    /**
     * 服务器回调
     */
    public function notify_callback($params,$order)
    {
        $data = file_get_contents('php://input');
        $data = json_decode($data,true);
        $signature = $data['sign'];
        unset($data['sign']);
        $sign = $this->sign($data, $this->account->params->key);
        if($sign && $sign == $signature) {
            if($data['status'] == 'SUCCESS') {
                // 金额异常检测
                if ($order->total_price != $params['amount']) {
                    record_file_log('LongyinAliScan_notify_error', '金额异常！' . "\r\n" . $order->trade_no . "\r\n订单金额：{$order->total_price}，已支付：{$params['amount']}");
                    die('金额异常！');
                }
                $this->completeOrder($order);
                exit('success');
            } else {
                exit('fail');
            }
        }
    }

    /**
     * @param $params
     * @return string
     */
    protected function sign($params, $apikey)
    {
        ksort($params);
        $keyStr = '';
        foreach ($params as $key => $val) {
            if($val != '') {
                $keyStr .= "$key=$val&";
            }
        }
        $sign = md5(trim($keyStr,'&'). $apikey);
        return $sign;
    }
}
?>